#ifndef KMODULE_H
#define KMODULE_H

#include <libkmod.h>

#include "global_types.h"

#include "kmodule_list.h"

typedef enum
{
	ADDED,
	DEPMOD_SCHEDULED,
	READY_TO_SCHEDULE,
	LOADING
} kmodule_state_t;

typedef struct kmodule_t kmodule_t;

error_code_t kmodule_init(void);

void kmodule_deinit(void);

kmodule_state_t kmodule_get_state(kmodule_t *kmodule);

void kmodule_set_state_depmod_scheduled(kmodule_t *kmodule, int depmod_cnt);

void kmodule_set_state_ready_to_schedule(kmodule_t *kmodule);

void kmodule_set_state_loading(kmodule_t *kmodule);


void kmodule_set_mainlist_entry(kmodule_t *kmodule, kmodule_list_entry_t *list_entry_pointer);

void kmodule_remove_from_main_list(kmodule_t *kmodule);

bool kmodule_all_depmods_loaded(kmodule_t *kmodule);

void kmodule_signal_depmod_loaded(kmodule_t *kmodule);


error_code_t kmodule_new_from_name(kmodule_t **kmodule, const char *name,const char *params);

error_code_t kmodule_new_from_path(kmodule_t **kmodule, const char *path,const char *params);

error_code_t kmodule_new_from_mod(kmodule_t **kmodule, struct kmod_module *mod,const char *params);

void kmodule_free(kmodule_t *kmodule);


error_code_t kmodule_load(kmodule_t *kmodule);


error_code_t kmodule_add_waiting_module(kmodule_t *kmodule, kmodule_t *waiting_kmodule);

void kmodule_signal_done_to_waiting_modules(kmodule_t *kmodule);

const struct kmod_module *kmodule_get_kmod(kmodule_t *kmodule);

const char * kmodule_get_name(kmodule_t *kmodule);

#endif
